package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.List;

import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="`workflowtype`",schema="hib")
public class WorkflowType extends ReferenceObject {

//TODO: match the resolver, update the resolver usage
	
	public static final int TYPE_ID_OPERATIONAL_REQUEST = 1;
	public static final int TYPE_ID_NDS = 2;
	public static final int TYPE_ID_RESEARCH_REQUEST = 3;
	public static final int TYPE_ID_INDEPENDENT = 4;
	public static final int TYPE_ID_PREPARATORY_REQUEST = 5;
	

	
	public static WorkflowType WF_OPERATIONAL_REQUEST;
	public static WorkflowType WF_NDS;
	public static WorkflowType WF_RESEARCH_REQUEST;
	public static WorkflowType WF_INDEPENDENT;	
	public static WorkflowType WF_PREPARATORY_REQUEST;
	
	private static boolean initialized = false;
	
	public static void initialize() {
		if (initialized == true) {
			return;
		}
				
		try {
			WF_OPERATIONAL_REQUEST = WorkflowType.findById(TYPE_ID_OPERATIONAL_REQUEST);
			WF_NDS = WorkflowType.findById(TYPE_ID_NDS);
			
			WF_RESEARCH_REQUEST = WorkflowType.findById(TYPE_ID_RESEARCH_REQUEST);
			WF_INDEPENDENT = WorkflowType.findById(TYPE_ID_INDEPENDENT);
			WF_PREPARATORY_REQUEST = WorkflowType.findById(TYPE_ID_PREPARATORY_REQUEST);


			initialized = true;	//successfully loaded all of the workflow types
		}
		catch (ObjectNotFoundException e) {
			e.printStackTrace();
		}
	}
	
	WorkflowType() {}	//default constructor, to avoid the "no default constructor" exception
	
	public WorkflowType( int typeId ) {
		id = typeId;
	}


	public static WorkflowType findById(final int workflowTypeId) throws ObjectNotFoundException {
		return DartObjectFactory.getInstance().getWorkflowTypeDAO().findById(workflowTypeId);
	}

	public static WorkflowType findByName(final String name) throws ObjectNotFoundException {
		return DartObjectFactory.getInstance().getWorkflowTypeDAO().findByName(name);
	}
	
	public static List<WorkflowType> listAll() { 
		return DartObjectFactory.getInstance().getWorkflowTypeDAO().listAll();
	}
}
